<?php
/**
 * Klasa Log
 */
class Log {
  /**
   * @var Log_Engine_Interface
   */
  protected $engine = false;
  
  /**
   * Dodanie zdarzenia do dziennika
   * 
   * @param string $message 
   */
  public function add($message)
  {
    if (!$this->engine) {
      throw new Exception('Nie można zapisać danych w dzienniku. Nie ustawiono mechanizmu składowania danych.');
    }
    
    $data['datetime'] = time();
    $data['message'] = $message;
    
    $session = Registry::get('session');
    $data['user'] = $session->getUserId();
    
    $this->engine->add($data);
  }
  
  /**
   * Ustawienie mechanizmu składowania danych dziennika
   * 
   * @param Log_Engine_Interface $Engine 
   */
  public function setEngine(Log_Engine_Interface $engine)
  {
    $this->engine = $engine;
  }
  
  /**
   * Pobranie mechanizmu składowania danych
   * 
   * @return Log_Engine_Interface 
   */
  public function getEngine()
  {
    return $this->engine;
  }
}

interface Log_Engine_Interface {
  /**
   * Dodanie zdarzenia do dziennika
   * 
   * @param string $message 
   */
  public function add(array $data);
}

class Log_Engine_File implements Log_Engine_Interface {
  /**
   * Dodanie zdarzenia do dziennika
   * 
   * @param string $message 
   */
  public function add(array $data)
  {
    $line = '[' .data('r', $data['datetime']). '] ' .$data['message']. ' User: ' .$data['user'] . PHP_EOL;
    
    $config = Registry::get('site-config');
    
    if (!file_put_contents($config['location'], $line, FILE_APPEND)) {
      throw new Exception("Podczas zapisu w pliku wystąpił błąd.");
    }
  }
}

$engine = new Log_Engine_File();

$log = new Log();
$log->setEngine($engine);

// Dodanie do rejestru
Registry::add($log);